return plane( "Tornado GR4", _("Tornado GR4"),
    {
        
        EmptyWeight = "14090",
        MaxFuelWeight = "4663",
        MaxHeight = "18000",
        MaxSpeed = "2340",
        MaxTakeOffWeight = "26490",
        Picture = "Tornado_GR3.png",
        Rate = "50",
        Shape = "TORNADO",
        WingSpan = "13.91",
        WorldID = F_2,
		
		Aliases = {"Tornado GR3"},

		-- Countermeasures
		passivCounterm = {
			CMDS_Edit = true,
			SingleChargeTotal = 180,
			chaff = {default = 90, increment = 30, chargeSz = 1},
			flare = {default = 45, increment = 15, chargeSz = 2}
        },
        
        attribute = {wsType_Air, wsType_Airplane, wsType_Fighter, F_2,
        "Bombers",
        },
        Categories = {
        },
        CanopyGeometry = makeAirplaneCanopyGeometry(LOOK_AVERAGE, LOOK_AVERAGE, LOOK_BAD),
        Sensors = {
            OPTIC = "Tornado GR_4 FLIR",
            RADAR = "AN/APG-63","Tornado SS radar",
            RWR = "Abstract RWR"
        },
        mapclasskey = "P0091000027",
    },
    {
        pylon(1, 0, -3.745000, -0.316000, -3.350000,
            {
				use_full_connector_position = true,
				FiX = 90,
            },
            {
                { CLSID = "{8C3F26A1-FA0F-11d5-9190-00A0249B6F00}" },
                { CLSID = "{8C3F26A2-FA0F-11d5-9190-00A0249B6F00}" },
                { CLSID = "{E6747967-B1F0-4C77-977B-AB2E6EB0C102}" },--ALARM
	            { CLSID = "{444BA8AE-82A7-4345-842E-76154EFCCA46}" }, -- LAU-117-AGM-65D
                { CLSID = "{DB434044-F5D0-4F1F-9BA9-B73027E18DD3}" }, -- AIM-9Mx2
				{ CLSID = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}" },--AIM-9M
				{ CLSID = "{2*AIM-120B}" },                          --LAU-7 2*AIM-120B
				{ CLSID = "{2*AIM-120C}" },                          --LAU-7 2*AIM-120C
                { CLSID = "ALQ_184" }, -- ALQ-184
				{ CLSID = "LAU-105_AIS_ASQ_T50_R" },	-- ACMI		
		        { CLSID = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}" },  -- Litening
				{ CLSID = "{6D21ECEA-F85B-4E8D-9D51-31DC9B8AA4EF}",arg = 52,arg_value = 0.2}, -- ALQ-131 ECM
				{ CLSID = "{8D399DDA-FF81-4F14-904D-099B34FE7918}" },
			    { CLSID = "{DB769D48-67D7-42ED-A2BE-108D566C8B1E}" },  -- GBU-12
			    { CLSID = "{5335D97A-35A5-4643-9D9B-026C75961E52}" }, -- CBU-97
			    { CLSID = "{CBU-87}" },
				{ CLSID = "{752B9781-F962-11d5-9190-00A0249B6F00}",arg = 52,arg_value = 0.3}, -- Durandal
				{ CLSID = "{C8E06185-7CD6-4C90-959F-044679E90751}" },
                { CLSID = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}" },
				{ CLSID = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}", arg_value = 0.0,attach_point_position = { -0.10, -0.008, 0.0}}, -- Mk-82	*
	            { CLSID = "{Mk82SNAKEYE}",							arg_value = 0.0,attach_point_position = { -0.10,  0.012, 0.0}}, -- Mk-82 Snakeye	*
				{CLSID = "{Matra155RocketPod}", arg_value = 0.25, required = {{station = 2,loadout = {"{Matra155RocketPod}"}}} }, -- Matra Type 155 Rocket pod
				{CLSID	=	"{ARAKM70BHE}"}, -- ARAK M70HE pod
				{CLSID	=	"{ARAKM70BAP}"}, -- ARAK M70AP pod
				{CLSID  =	"{KB}" }, -- KB countermeasure dispenser
				{CLSID  =	"{U22}" }, -- U22 jammer
				{CLSID  =	"{U22A}" }, -- U22/A jammer
            }
        ),
        pylon(2, 1, -1.280000, -0.486000, -2.018000,
            {
 				use_full_connector_position = true,
				FiX = 90,
            },
            {
                { CLSID = "{EF124821-F9BB-4314-A153-E0E2FE1162C4}" },
				{ CLSID = "{FPU_8A_FUEL_TANK}"						},	-- Fuel tank
				{ CLSID = "{DB434044-F5D0-4F1F-9BA9-B73027E18DD3}" }, -- AIM-9Mx2
				{CLSID	=	"{ARAKM70BHE}"}, -- ARAK M70HE pod
				{CLSID	=	"{ARAKM70BAP}"}, -- ARAK M70AP pod
	            { CLSID = "{8D399DDA-FF81-4F14-904D-099B34FE7918}" },
				{ CLSID = "{AB8B8299-F1CC-4359-89B5-2172E0CF4A5A}", arg_value = 0.0}, -- Mk-84
				{ CLSID = "{EF0A9419-01D6-473B-99A3-BEBDB923B14D}" }, -- GBU-27
				{ CLSID = "{D5D51E24-348C-4702-96AF-97A714E72697}",arg = 52,arg_value = 0.3}, -- MER*2 MK-82
				{ CLSID = "{18617C93-78E7-4359-A8CE-D754103EDF63}",arg = 52,arg_value = 0.3}, -- MER*2 MK-83
				{CLSID = "{M2KC_RAFAUT_GBU12}", arg_value = 0.25 }, -- GBU-12 x2
			    { CLSID = "{444BA8AE-82A7-4345-842E-76154EFCCA46}" }, -- LAU-117-AGM-65D
			    { CLSID = "{E6747967-B1F0-4C77-977B-AB2E6EB0C102}" },--ALARM
				{ CLSID = "{0B9ABA77-93B8-45FC-9C63-82AFB2CB50A4}" }, -- Mk-20*2
				{ CLSID = "{5335D97A-35A5-4643-9D9B-026C75961E52}" }, -- CBU-97
				{ CLSID = "{CBU-87}" },
			    { CLSID = "{C8E06185-7CD6-4C90-959F-044679E90751}" },
                { CLSID = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}" },
				{ CLSID = "{2*AIM-120B}" },                          --LAU-7 2*AIM-120B
				{ CLSID = "{2*AIM-120C}" },                          --LAU-7 2*AIM-120C
				{CLSID = "{M2KC_RAFAUT_MK82S}", arg_value = 0.35, required = {{station = 8,loadout = {"{M2KC_RAFAUT_MK82S}"}}} }, -- MK-82S x2
			    { CLSID = "{ADD3FAE1-EBF6-4EF9-8EFC-B3MERB3100CA}",arg = 52,arg_value = 0.3}, -- BLG-66 BELOUGA*2
				{ CLSID = "{752B9781-F962-11d5-9190-00A0249B6F00}",arg = 52,arg_value = 0.3}, -- Durandal
				{CLSID = "{Matra155RocketPod}", arg_value = 0.25, required = {{station = 2,loadout = {"{Matra155RocketPod}"}}} }, -- Matra Type 155 Rocket pod
            }
        ),
        pylon(3, 1, -0.993000, 0.013000, -1.688000,
            {
				use_full_connector_position = true,
				FiX = 90,
            },
            {
                { CLSID = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}" },
                { CLSID = "{E6747967-B1F0-4C77-977B-AB2E6EB0C102}" },
                { CLSID = "{AIS_ASQ_T50}", attach_point_position = {0.40,  0.0,  0.0}},			-- ACMI pod
				{ CLSID = "{444BA8AE-82A7-4345-842E-76154EFCCA46}" }, -- LAU-117-AGM-65D
				{ CLSID = "{8D399DDA-FF81-4F14-904D-099B34FE7918}" },
			    { CLSID = "{C8E06185-7CD6-4C90-959F-044679E90751}" },
                { CLSID = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}" },
            }
        ),
        pylon(4, 1, -0.246000, -0.997000, -0.547000,
            {
				use_full_connector_position = true,
				FiX = 90,
            },
            {
                { CLSID = "{0D33DDAE-524F-4A4E-B5B8-621754FE3ADE}" },
                { CLSID = "{E6747967-B1F0-4C77-977B-AB2E6EB0C102}" },
                { CLSID = "{1461CD18-429A-42A9-A21F-4C621ECD4573}" },
				{ CLSID = "{EF0A9419-01D6-473B-99A3-BEBDB923B14D}" }, -- GBU-27
				{ CLSID = "{DB769D48-67D7-42ED-A2BE-108D566C8B1E}" },  -- GBU-12
				{ CLSID = "{8D399DDA-FF81-4F14-904D-099B34FE7918}" },
				{ CLSID = "{AB8B8299-F1CC-4359-89B5-2172E0CF4A5A}", arg_value = 0.0}, -- Mk-84
			    { CLSID = "{7A44FF09-527C-4B7E-B42B-3F111CFE50FB}", arg_value = 0.0}, -- Mk-83
			    { CLSID = "{444BA8AE-82A7-4345-842E-76154EFCCA46}" }, -- LAU-117-AGM-65D
				{ CLSID = "{5335D97A-35A5-4643-9D9B-026C75961E52}" }, -- CBU-97
				{ CLSID = "{CBU-87}" },
			    { CLSID = "{752B9781-F962-11d5-9190-00A0249B6F00}",arg = 52,arg_value = 0.3}, -- Durandal
				{ CLSID = "{C8E06185-7CD6-4C90-959F-044679E90751}" },
                { CLSID = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}" },
				{CLSID	=	"{ARAKM70BHE}"}, -- ARAK M70HE pod
				{CLSID	=	"{ARAKM70BAP}"}, -- ARAK M70AP pod
			}
        ),
        pylon(5, 1, 1.436000, -0.997000, -0.546000,
            {
				use_full_connector_position = true,
				FiX = 90,
            },
            {
                { CLSID = "{DB769D48-67D7-42ED-A2BE-108D566C8B1E}" },  -- GBU-12	
				{ CLSID = "{8D399DDA-FF81-4F14-904D-099B34FE7918}" },
				{ CLSID = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}", arg_value = 0.0,attach_point_position = { -0.10, -0.008, 0.0}}, -- Mk-82	*
	            { CLSID = "{Mk82SNAKEYE}",							arg_value = 0.0,attach_point_position = { -0.10,  0.012, 0.0}}, -- Mk-82 Snakeye	*
	            { CLSID = "{7A44FF09-527C-4B7E-B42B-3F111CFE50FB}", arg_value = 0.0}, -- Mk-83	
				{ CLSID = "{444BA8AE-82A7-4345-842E-76154EFCCA46}" }, -- LAU-117-AGM-65D
			    { CLSID = "{5335D97A-35A5-4643-9D9B-026C75961E52}" }, -- CBU-97
			    { CLSID = "{CBU-87}" },
				{ CLSID = "{752B9781-F962-11d5-9190-00A0249B6F00}",arg = 52,arg_value = 0.3}, -- Durandal
				{ CLSID = "{C8E06185-7CD6-4C90-959F-044679E90751}" },
                { CLSID = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}" },
				{ CLSID = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}" },  -- Litening
            }
        ),
        pylon(6, 1, -1.100000, -0.997000, -0.546000,
            {
				use_full_connector_position = true,
				FiX = 90,
            },
            {
				{ CLSID = "{DB769D48-67D7-42ED-A2BE-108D566C8B1E}" },  -- GBU-12	
				{ CLSID = "{8D399DDA-FF81-4F14-904D-099B34FE7918}" },	
	            { CLSID = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}", arg_value = 0.0,attach_point_position = { -0.10, -0.008, 0.0}}, -- Mk-82	*
	            { CLSID = "{Mk82SNAKEYE}",							arg_value = 0.0,attach_point_position = { -0.10,  0.012, 0.0}}, -- Mk-82 Snakeye	*
	            { CLSID = "{7A44FF09-527C-4B7E-B42B-3F111CFE50FB}", arg_value = 0.0}, -- Mk-83		
				{ CLSID = "{444BA8AE-82A7-4345-842E-76154EFCCA46}" }, -- LAU-117-AGM-65D	
                { CLSID = "{5335D97A-35A5-4643-9D9B-026C75961E52}" }, -- CBU-97	
				{ CLSID = "{CBU-87}" },
				{ CLSID = "{752B9781-F962-11d5-9190-00A0249B6F00}",arg = 52,arg_value = 0.3}, -- Durandal
                { CLSID = "{C8E06185-7CD6-4C90-959F-044679E90751}" },
                { CLSID = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}" },				
            }
        ),
        pylon(7, 1, -1.100000, -0.997000, 0.546000,
            {
				use_full_connector_position = true,
				FiX = 90,
            },
            {
			    { CLSID = "{DB769D48-67D7-42ED-A2BE-108D566C8B1E}" },  -- GBU-12	
				{ CLSID = "{8D399DDA-FF81-4F14-904D-099B34FE7918}" },	
	            { CLSID = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}", arg_value = 0.0,attach_point_position = { -0.10, -0.008, 0.0}}, -- Mk-82	*
	            { CLSID = "{Mk82SNAKEYE}",							arg_value = 0.0,attach_point_position = { -0.10,  0.012, 0.0}}, -- Mk-82 Snakeye	*
	            { CLSID = "{7A44FF09-527C-4B7E-B42B-3F111CFE50FB}", arg_value = 0.0}, -- Mk-83	
				{ CLSID = "{444BA8AE-82A7-4345-842E-76154EFCCA46}" }, -- LAU-117-AGM-65D	
                { CLSID = "{5335D97A-35A5-4643-9D9B-026C75961E52}" }, -- CBU-97	
				{ CLSID = "{CBU-87}" },				
				{ CLSID = "{752B9781-F962-11d5-9190-00A0249B6F00}",arg = 52,arg_value = 0.3}, -- Durandal
                { CLSID = "{C8E06185-7CD6-4C90-959F-044679E90751}" },
                { CLSID = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}" },				
            }
        ),
        pylon(8, 1, 1.436000, -0.997000, 0.546000,
            {
				use_full_connector_position = true,
				FiX = 90,
            },
            {
			    { CLSID = "{DB769D48-67D7-42ED-A2BE-108D566C8B1E}" },  -- GBU-12
				{ CLSID = "{8D399DDA-FF81-4F14-904D-099B34FE7918}" },
	            { CLSID = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}", arg_value = 0.0,attach_point_position = { -0.10, -0.008, 0.0}}, -- Mk-82	*
	            { CLSID = "{Mk82SNAKEYE}",							arg_value = 0.0,attach_point_position = { -0.10,  0.012, 0.0}}, -- Mk-82 Snakeye	*
	            { CLSID = "{7A44FF09-527C-4B7E-B42B-3F111CFE50FB}", arg_value = 0.0}, -- Mk-83	
				{ CLSID = "{444BA8AE-82A7-4345-842E-76154EFCCA46}" }, -- LAU-117-AGM-65D	
                { CLSID = "{5335D97A-35A5-4643-9D9B-026C75961E52}" }, -- CBU-97	
				{ CLSID = "{CBU-87}" },
				{ CLSID = "{752B9781-F962-11d5-9190-00A0249B6F00}",arg = 52,arg_value = 0.3}, -- Durandal	
                { CLSID = "{C8E06185-7CD6-4C90-959F-044679E90751}" },
                { CLSID = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}" },
		        { CLSID = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}" },  -- Litening				
			
            }
        ),
        pylon(9, 0, -0.246000, -0.997000, 0.547000,
            {
				use_full_connector_position = true,
				FiX = 90,
            },
            {
                { CLSID = "{0D33DDAE-524F-4A4E-B5B8-621754FE3ADE}" },
                { CLSID = "{E6747967-B1F0-4C77-977B-AB2E6EB0C102}" },
                { CLSID = "{1461CD18-429A-42A9-A21F-4C621ECD4573}" },
				{ CLSID = "{EF0A9419-01D6-473B-99A3-BEBDB923B14D}" }, -- GBU-27
				{ CLSID = "{DB769D48-67D7-42ED-A2BE-108D566C8B1E}" },  -- GBU-12
				{ CLSID = "{8D399DDA-FF81-4F14-904D-099B34FE7918}" },
				{ CLSID = "{AB8B8299-F1CC-4359-89B5-2172E0CF4A5A}", arg_value = 0.0}, -- Mk-84
			    { CLSID = "{7A44FF09-527C-4B7E-B42B-3F111CFE50FB}", arg_value = 0.0}, -- Mk-83
		        { CLSID = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}" },  -- Litening
			    { CLSID = "{5335D97A-35A5-4643-9D9B-026C75961E52}" }, -- CBU-97
				{ CLSID = "{CBU-87}" },
				{ CLSID = "{752B9781-F962-11d5-9190-00A0249B6F00}",arg = 52,arg_value = 0.3}, -- Durandal
			    { CLSID = "{C8E06185-7CD6-4C90-959F-044679E90751}" },
                { CLSID = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}" },
				{CLSID	=	"{ARAKM70BHE}"}, -- ARAK M70HE pod
				{CLSID	=	"{ARAKM70BAP}"}, -- ARAK M70AP pod
            }
        ),
        pylon(10, 1, -0.993000, 0.013000, 1.688000,
            {
				use_full_connector_position = true,
				FiX = 90,
            },
            {
                { CLSID = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}" },
                { CLSID = "{E6747967-B1F0-4C77-977B-AB2E6EB0C102}" },
                { CLSID = "{AIS_ASQ_T50}", attach_point_position = {0.40,  0.0,  0.0}},			-- ACMI pod
				{ CLSID = "{8D399DDA-FF81-4F14-904D-099B34FE7918}" },
			    { CLSID = "{C8E06185-7CD6-4C90-959F-044679E90751}" },
                { CLSID = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}" },
			    { CLSID = "{444BA8AE-82A7-4345-842E-76154EFCCA46}" }, -- LAU-117-AGM-65D
            }
        ),
        pylon(11, 0, -1.280000, -0.486000, 2.018000,
            {
				use_full_connector_position = true,
				FiX = 90,
            },
            {
                { CLSID = "{EF124821-F9BB-4314-A153-E0E2FE1162C4}" },
				{ CLSID = "{FPU_8A_FUEL_TANK}"						},	-- Fuel tank
				{CLSID	=	"{ARAKM70BHE}"}, -- ARAK M70HE pod
				{CLSID	=	"{ARAKM70BAP}"}, -- ARAK M70AP pod
				{ CLSID = "{8D399DDA-FF81-4F14-904D-099B34FE7918}" },
				{ CLSID = "{AB8B8299-F1CC-4359-89B5-2172E0CF4A5A}", arg_value = 0.0}, -- Mk-84
				{ CLSID = "{EF0A9419-01D6-473B-99A3-BEBDB923B14D}" }, -- GBU-27
				{ CLSID = "{D5D51E24-348C-4702-96AF-97A714E72697}",arg = 52,arg_value = 0.3}, -- MER*2 MK-82
				{ CLSID = "{18617C93-78E7-4359-A8CE-D754103EDF63}",arg = 52,arg_value = 0.3}, -- MER*2 MK-83
				{CLSID = "{M2KC_RAFAUT_GBU12}", arg_value = 0.25 }, -- GBU-12 x2
			    { CLSID = "{444BA8AE-82A7-4345-842E-76154EFCCA46}" }, -- LAU-117-AGM-65D
			    { CLSID = "{E6747967-B1F0-4C77-977B-AB2E6EB0C102}" },--ALARM
				{ CLSID = "{0B9ABA77-93B8-45FC-9C63-82AFB2CB50A4}" }, -- Mk-20*2
				{ CLSID = "{5335D97A-35A5-4643-9D9B-026C75961E52}" }, -- CBU-97
				{ CLSID = "{CBU-87}" },
				{CLSID = "{M2KC_RAFAUT_MK82S}", arg_value = 0.35, required = {{station = 8,loadout = {"{M2KC_RAFAUT_MK82S}"}}} }, -- MK-82S x2
				{ CLSID = "{ADD3FAE1-EBF6-4EF9-8EFC-B3MERB3100CA}",arg = 52,arg_value = 0.3}, -- BLG-66 BELOUGA*2
				{ CLSID = "{752B9781-F962-11d5-9190-00A0249B6F00}",arg = 52,arg_value = 0.3}, -- Durandal
				{CLSID = "{Matra155RocketPod}", arg_value = 0.25, required = {{station = 2,loadout = {"{Matra155RocketPod}"}}} }, -- Matra Type 155 Rocket pod
				{ CLSID = "{C8E06185-7CD6-4C90-959F-044679E90751}" },
                { CLSID = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}" },
				{ CLSID = "{2*AIM-120B}" },                          --LAU-7 2*AIM-120B
				{ CLSID = "{2*AIM-120C}" },                          --LAU-7 2*AIM-120C
				{ CLSID = "{DB434044-F5D0-4F1F-9BA9-B73027E18DD3}" }, -- AIM-9Mx2
            }
        ),
        pylon(12, 0, -3.745000, -0.316000, 3.350000,
            {
				use_full_connector_position = true,
				FiX = 90,
            },
            {
                { CLSID = "{8C3F26A1-FA0F-11d5-9190-00A0249B6F00}" },
                { CLSID = "{8C3F26A2-FA0F-11d5-9190-00A0249B6F00}" },
                { CLSID = "{8C3F26A1-FA0F-11d5-9190-00A0249B6F00}" },
                { CLSID = "{8C3F26A2-FA0F-11d5-9190-00A0249B6F00}" },
                { CLSID = "{E6747967-B1F0-4C77-977B-AB2E6EB0C102}" },--ALARM
	            { CLSID = "{444BA8AE-82A7-4345-842E-76154EFCCA46}" }, -- LAU-117-AGM-65D
                { CLSID = "{DB434044-F5D0-4F1F-9BA9-B73027E18DD3}" }, -- AIM-9Mx2
				{ CLSID = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}" },--AIM-9M
				{ CLSID = "{2*AIM-120B}" },                          --LAU-7 2*AIM-120B
				{ CLSID = "{2*AIM-120C}" },                          --LAU-7 2*AIM-120C
                { CLSID = "ALQ_184" }, -- ALQ-184
				{ CLSID = "LAU-105_AIS_ASQ_T50_R" },	-- ACMI		
		        { CLSID = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}" },  -- Litening
			    { CLSID = "{6D21ECEA-F85B-4E8D-9D51-31DC9B8AA4EF}",arg = 52,arg_value = 0.2}, -- ALQ-131 ECM
				{ CLSID = "{8D399DDA-FF81-4F14-904D-099B34FE7918}" },
			    { CLSID = "{DB769D48-67D7-42ED-A2BE-108D566C8B1E}" },  -- GBU-12
				{ CLSID = "{5335D97A-35A5-4643-9D9B-026C75961E52}" }, -- CBU-97
				{ CLSID = "{C8E06185-7CD6-4C90-959F-044679E90751}" },
                { CLSID = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}" },
				{ CLSID = "{CBU-87}" },
				{ CLSID = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}", arg_value = 0.0,attach_point_position = { -0.10, -0.008, 0.0}}, -- Mk-82	*
	            { CLSID = "{Mk82SNAKEYE}",							arg_value = 0.0,attach_point_position = { -0.10,  0.012, 0.0}}, -- Mk-82 Snakeye	*
				{CLSID = "{Matra155RocketPod}", arg_value = 0.25, required = {{station = 2,loadout = {"{Matra155RocketPod}"}}} }, -- Matra Type 155 Rocket pod
				{ CLSID = "{752B9781-F962-11d5-9190-00A0249B6F00}",arg = 52,arg_value = 0.3}, -- Durandal
				{CLSID	=	"{ARAKM70BHE}"}, -- ARAK M70HE pod
				{CLSID	=	"{ARAKM70BAP}"}, -- ARAK M70AP pod
				{CLSID  =	"{U22}" }, -- U22 jammer
				{CLSID  =	"{U22A}" }, -- U22/A jammer				
				{CLSID  =	"{KB}" }, -- KB countermeasure dispenser
				
            }
        ),
    },
    {
        aircraft_task(PinpointStrike),
        aircraft_task(GroundAttack),
        aircraft_task(SEAD),
        aircraft_task(AFAC),
        aircraft_task(AntishipStrike),
        aircraft_task(Reconnaissance),
		aircraft_task(CAS),
		aircraft_task(CAP),
		aircraft_task(Escort),
		aircraft_task(Intercept),
		aircraft_task(FighterSweep),
		
    },
	aircraft_task(GroundAttack)
);
